#!/usr/bin/perl
#-------------------------------------------------------------------
# adduser.cgi		CGI perl script to add an user to a Linux
#			box. It is supposed to be called by an
#			HTML form.
#
# Version		1.2	15 Jan 2000
#
# Author:		Niccolo Rigacci <rigacci@iname.com>
#-------------------------------------------------------------------

# Digits used to generate username: must be between 1 and 6.
$USERNAME_DIGITS = 1;
# Max input len, to avoid buffer overflow?
$MAX_INPUT_LEN = 255;
# Maximum number of user allowed.
$MAX_USERS = 112;

@errmsg = ("First name is not valid",
           "Last name is not valid",
           "E-mail alias is not valid",
           "E-mail alias exists",
           "E-mail alias exists as user",
           "Password is not valid",
           "Passwords don't match",
           "Can't generate unique username",
           "Reached maximum number of users");

#-------------------------------------------------------------------
# Preliminary check: put whatever you want here.
#-------------------------------------------------------------------
# This is a suid perl script, must explicitly set the PATH.
$ENV{'PATH'} = "/sbin:/bin:/usr/sbin:/usr/bin";
# I check that there are not more than the allowed accounts.
$users_count = `cat /etc/passwd | wc -l`;
&err(8) if $users_count > $MAX_USERS;

#-------------------------------------------------------------------
# Read standard input and split it in an associative array.
#-------------------------------------------------------------------
# Determine input lenght and read it.
$i = $ENV{'CONTENT_LENGTH'};
$i = ($i > $MAX_INPUT_LEN) ? $MAX_INPUT_LEN : $i;
read(STDIN, $request, $i);
if ($request =~ /=/) {
   %request = &UrlDecode(split(/[&=]/, $request));}

#-------------------------------------------------------------------
# Check FIRSTNAME: 2 to 20 alphanum chars with spaces inside.
#-------------------------------------------------------------------
# Remove leading and trailing spaces.
$request{'FIRSTNAME'} =~ s/^ +//;
$request{'FIRSTNAME'} =~ s/ +$//;
&err(0) if !($request{'FIRSTNAME'} =~ /^[ \w]{2,20}$/);

#-------------------------------------------------------------------
# Check LASTNAME: 2 to 20 alphanum chars with spaces inside.
#-------------------------------------------------------------------
# Remove leading and trailing spaces.
$request{'LASTNAME'} =~ s/^ +//;
$request{'LASTNAME'} =~ s/ +$//;
&err(1) if !($request{'LASTNAME'} =~ /^[ \w]{2,20}$/);

#-------------------------------------------------------------------
# Check ALIAS.
#-------------------------------------------------------------------
# Remove leading and trailing spaces.
$request{'ALIAS'} =~ s/^ +//;
$request{'ALIAS'} =~ s/ +$//;
# Lowercase it.
$request{'ALIAS'} = lc($request{'ALIAS'});
# Check for len between 2 and 20 chars.
&err(2) if !($request{'ALIAS'} =~ /^[\.\w]{2,20}$/);
# Check if already exists as alias.
&err(3) if &contain("^\\s*" . $request{'ALIAS'} . "\\s*:", "/etc/aliases");
# Check if already exists as user.
&err(4) if &contain("^" . $request{'ALIAS'} . ":", "/etc/passwd");

#-------------------------------------------------------------------
# Check PASSWD.
#-------------------------------------------------------------------
# Check for len between 4 and 8 chars.
&err(5) if !($request{'PASSWD'} =~ /^.{4,8}$/);
&err(6) if ($request{'PASSWD'} ne $request{'PASSWD_CONFIRM'});

#-------------------------------------------------------------------
# Generate an unique username using initials plus a random number.
#-------------------------------------------------------------------
$try = 0;
$uniq = '';
# Try several times to generate a random unique username.
while ($try++ < (10 ** $USERNAME_DIGITS) && !$uniq) {
   $username = lc(substr($request{'FIRSTNAME'}, 0, 1)) .
      lc(substr($request{'LASTNAME'}, 0, 1)) .
      sprintf("%0" . $USERNAME_DIGITS . "d",
      int(rand(10 ** $USERNAME_DIGITS)));
   $uniq = !(&contain("^" . $username . ":", "/etc/passwd"));
   }
&err(7) if !$uniq;
# Gecos is first and last name.
$gecos = $request{'FIRSTNAME'} . " " . $request{'LASTNAME'};

#-------------------------------------------------------------------
# Create the account: the script must be suid root.
#-------------------------------------------------------------------
# Set environment and "untaint" variables for security.
($EUID, $EGID) = (0, 0);
$username =~ /(\S+)/;
$untainted_username = "$1";
$gecos =~ /(.+)/;
$untainted_gecos = "$1";
$request{'PASSWD'} =~ /(.+)/;
$untainted_passwd = "$1";
$request{'ALIAS'} =~ /(\S+)/;
$untainted_alias = "$1";
# Create the user, set password, alias, ...
system("/usr/sbin/useradd -c \"$untainted_gecos\" -g users -m -s /bin/false $untainted_username");
system("echo $untainted_username:\"$untainted_passwd\" | chpasswd");
system("echo $untainted_alias: $untainted_username >> /etc/aliases");

#-------------------------------------------------------------------
# Output the result.
#-------------------------------------------------------------------
print "Content-type: text/html\n\n";
print "<HTML>\n";
print "<HEAD><TITLE>Account created</TITLE></HEAD>\n";
print "<BODY BGCOLOR=\"#FFFFF\">\n";
print "<H1>Account creation report</H1>\n";
print "<PRE>\n";
print "Username:     " . $untainted_username . "\n";
print "Password:     " . $untainted_passwd . "\n";
print "Comment:      " . $untainted_gecos . "\n";
print "E-mail alias: " . $untainted_alias . "\n";
print "Timestamp:    " . localtime() . "\n";
print "IP address:   " . $ENV{'REMOTE_ADDR'} . "\n";
print "</PRE>\n";
print "</BODY>\n";
print "</HTML>\n";
die;
                           
#-------------------------------------------------------------------
# Output an error page and die.
#-------------------------------------------------------------------
sub err {
   local ($errno) = @_;
   print "Content-type: text/html\n\n";
   print "<HTML>\n";
   print "<HEAD><TITLE>Error</TITLE></HEAD>\n";
   print "<BODY BGCOLOR=\"#FFFFFF\">\n";
   print "<H1>Account creation error</H1>\n";
   print "<H3>" . $errmsg[$errno] . "</H3>" . "\n";
   print "Click the Back button of your browser and make the correction.\n";
   print "</BODY>\n";
   print "</HTML>\n";
   die;
   }

#-------------------------------------------------------------------
# Decode a URL encoded string or array of strings 
# 1.      Change "+" to space, since FORMS change space to "+"
# 2.      Change "%XX" to character with hex value "XX"
#-------------------------------------------------------------------
sub UrlDecode {
   foreach (@_) {
      tr/+/ /;
      s/%(..)/pack("c",hex($1))/ge;
      }
   wantarray ? @_ : $_[$[];
   }

#-------------------------------------------------------------------
# Search a file for a regeular expression.
#-------------------------------------------------------------------
sub contain {
   local($regexp, $file) = @_;
   open (INDATA, $file);
   while (<INDATA>) {
      /$regexp/ && return 1; }
   return 0;
   }
