#!/usr/bin/perl
#-------------------------------------------------------------------
# adduser.pl		CGI perl script to add an user to a Linux
#			box. It is supposed to be called by an
#			HTML form.
#
# Version		1.5	?? Feb 2000
#
# Author:		Niccolo Rigacci <rigacci@iname.com>
#-------------------------------------------------------------------

# Initial login group.
$INITIAL_GROUP = 'mbox';

# User prototype for setting quota.
$QUOTA_PROTO_USER = 'mboxprot';

# Mail domain (shown after account creation).
$MAIL_DOMAIN = 'apinforma.com';

# Maximum number of user allowed.
$MAX_USERS = 500;

# Where to write the log.
$LOG_FILE = '/var/log/adduser.cgi.log';

# Digits used to generate username: must be between 1 and 6.
$USERNAME_DIGITS = 3;

# Max input len (to avoid buffer overflow?).
$MAX_INPUT_LEN = 255;

# This is a suid perl script: must explicitly set the PATH.
# Starting from version 1.4 it is not longer true: the script
# is run by a suid wrapper. But some check doesn't hurt.
$ENV{'PATH'} = '/sbin:/bin:/usr/sbin:/usr/bin';

# English error messages.
@errmsg = ("First name is not valid",
           "Last name is not valid",
           "E-mail alias is not valid",
           "E-mail alias already exists",
           "E-mail alias already exists as user",
           "Password is not valid",
           "Passwords don't match",
           "Can't generate unique username",
           "Reached maximum number of users");

# Italian error messages.
@errmsg = ("Il nome non &egrave; valido",
           "Il cognome non &egrave; valido",
           "L'indirizzo e-mail non &egrave; valido",
           "L'indirizzo e-mail esiste gi&agrave;",
           "L'indirizzo e-mail esiste gi&agrave;",
           "La password non &egrave; valida",
           "Le password non coincidono",
           "Impossibile generare uno username univoco",
           "Raggiunto il massimo numero di iscritti");

#-------------------------------------------------------------------
# Preliminary check: put whatever you want here.
#-------------------------------------------------------------------
# I check that there are not more than the allowed accounts.
&err(8) if `/bin/cat /etc/passwd | /usr/bin/wc -l` > $MAX_USERS;

#-------------------------------------------------------------------
# Read standard input and split it in an associative array.
#-------------------------------------------------------------------
# Determine input lenght and read it.
$i = $ENV{'CONTENT_LENGTH'};
$i = ($i > $MAX_INPUT_LEN) ? $MAX_INPUT_LEN : $i;
read(STDIN, $request, $i);
if ($request =~ /=/) {
   %request = &UrlDecode(split(/[&=]/, $request));}

#-------------------------------------------------------------------
# Check FIRSTNAME: 2 to 20 alphanum chars with spaces inside.
#-------------------------------------------------------------------
# Remove leading and trailing spaces.
$request{'FIRSTNAME'} =~ s/^ +//;
$request{'FIRSTNAME'} =~ s/ +$//;
&err(0) if !($request{'FIRSTNAME'} =~ /^[ \w\200-\377]{2,20}$/);

#-------------------------------------------------------------------
# Check LASTNAME: 2 to 20 alphanum chars with spaces inside.
#-------------------------------------------------------------------
# Remove leading and trailing spaces.
$request{'LASTNAME'} =~ s/^ +//;
$request{'LASTNAME'} =~ s/ +$//;
&err(1) if !($request{'LASTNAME'} =~ /^[ \w\200-\377]{2,20}$/);

#-------------------------------------------------------------------
# Check ALIAS.
#-------------------------------------------------------------------
# Remove leading and trailing spaces.
$request{'ALIAS'} =~ s/^ +//;
$request{'ALIAS'} =~ s/ +$//;

# Check for len between 1 and 20 chars.
&err(2) if !($request{'ALIAS'} =~ /^.{1,20}$/);

# Check for RFC822 compliance.
# An atom is any CHAR (0-127 ASCII) except SPACE, specials and
# CTLs (0-31 and 127 ASCII). See RFC822.
$atom = '^\ \(\)\<\>\@\,\;\:\\\"\.\[\]\000-\037\177-\377';
# This check is more restrictive than what is allowed by RFC822
# as the local-part for an e-mail address.
&err(2) if !($request{'ALIAS'} =~ /^[$atom]+(\.[$atom]+)*$/);

# Check if already exists as alias.
$regexp = '^\s*' . quotemeta($request{'ALIAS'}) . '\s*:';
&err(3) if &search($regexp, '/etc/aliases');
# Check if already exists as user.
$regexp = '^' . quotemeta($request{'ALIAS'}) . ':';
&err(4) if &search($regexp, '/etc/passwd');

#-------------------------------------------------------------------
# Check PASSWD.
#-------------------------------------------------------------------
# Check for len between 4 and 8 chars.
&err(5) if !($request{'PASSWD'} =~ /^.{4,8}$/);
&err(6) if ($request{'PASSWD'} ne $request{'PASSWD_CONFIRM'});

#-------------------------------------------------------------------
# Generate an unique username using initials plus a random number.
#-------------------------------------------------------------------
$try = 0;
$uniq = '';
# Try several times to generate a random unique username.
while ($try++ < (10 ** $USERNAME_DIGITS) && !$uniq) {
   $username = lc(substr($request{'FIRSTNAME'}, 0, 1)) .
      lc(substr($request{'LASTNAME'}, 0, 1)) .
      sprintf('%0' . $USERNAME_DIGITS . 'd',
      int(rand(10 ** $USERNAME_DIGITS)));
   $uniq = !(&search('^' . $username . ':', '/etc/passwd'));
   }
&err(7) if !$uniq;
# Gecos is first and last name.
$gecos = $request{'FIRSTNAME'} . " " . $request{'LASTNAME'};

#-------------------------------------------------------------------
# Create the account (the script must be suid root).
#-------------------------------------------------------------------
# "Untaint" variables for security.
# As stated above the script (from version 1.4) is run by a suid
# wrapper, so something here is unnecessary.
$username =~ /(.+)/;
$untainted_username = "$1";
$gecos =~ /(.+)/;
$untainted_gecos = "$1";
$request{'PASSWD'} =~ /(.+)/;
$untainted_passwd = "$1";
$request{'ALIAS'} =~ /(.+)/;
$untainted_alias = "$1";
#-------------------------------------------------------------------
# Create the user.
#-------------------------------------------------------------------
# Calling system with a separate list, does not go through a shell.
system '/usr/sbin/useradd', '-c', "$untainted_gecos",
       '-g', "$INITIAL_GROUP", '-m', '-s', '/bin/false',
       "$untainted_username";
#-------------------------------------------------------------------
# Set the password. For security do it without executing a shell!
#-------------------------------------------------------------------
# Fork a perl process; the child execs chpasswd.
my $result = open (CHPASSWD, "|-"); die unless defined($result);
exec '/usr/sbin/chpasswd' if $result == 0;
# The parent sends the input to the child.
print CHPASSWD "$untainted_username", ':', "$untainted_passwd", "\n";
close CHPASSWD;
#-------------------------------------------------------------------
# Add the alias.
#-------------------------------------------------------------------
open (ALIASES, '>> /etc/aliases') || die;
print ALIASES "$untainted_alias", ': ', "$untainted_username", "\n";
close ALIASES;
#-------------------------------------------------------------------
# Activate quota for the user.
#-------------------------------------------------------------------
system '/usr/sbin/edquota', '-p', "$QUOTA_PROTO_USER",
       '-u', "$untainted_username";

#-------------------------------------------------------------------
# Get some additional info.
#-------------------------------------------------------------------
$timestamp = localtime();
$ipaddress = $ENV{'REMOTE_ADDR'};

#-------------------------------------------------------------------
# Update log with new account data.
#-------------------------------------------------------------------
open (LOG, ">> $LOG_FILE") || die;
print LOG $untainted_username, ",";
print LOG $untainted_gecos, ",";
print LOG $untainted_alias, ",";
print LOG $timestamp, ",";
print LOG $ipaddress, "\n";
close LOG;

#-------------------------------------------------------------------
# Output the result.
#-------------------------------------------------------------------
print "Content-type: text/html\n\n";
print "<HTML>\n";
print "<HEAD><TITLE>Account creato</TITLE></HEAD>\n";
print "<BODY BGCOLOR=\"#FFFFF\">\n";
print "<H1>Account creato con successo</H1>\n";
print "<HR>\n";
print "<H3>Informazioni per accedere al servizio</H3>\n";
print "<PRE>\n";
print "Username          " . $untainted_username . "\n";
print "Password          " . $untainted_passwd . "\n";
print "Commento          " . $untainted_gecos . "\n";
print "Indirizzo e-mail  " . $untainted_alias . '@' . $MAIL_DOMAIN . "\n";
print "Server web        http://mail.apinforma.com/\n";
print "Server POP3/IMAP  mail.apinforma.com\n";
print "\n";
print "Ora di creazione  " . $timestamp . "\n";
print "Vs indirizzo IP   " . $ipaddress . "\n";
print "</PRE>\n";
print "Si consiglia di prendere nota (o stampare) le informazioni sopra riportate.\n";
print "In particolar modo Username e Password, senza le quali sar&agrave; impossibile accedere alla mailbox creata.";
print "<HR>\n";
print "<A HREF=\"/imp/\">Esegui il login adesso</A><BR>\n";
print "<A HREF=\"/\">Torna alla Home page</A>\n";
print "</BODY>\n";
print "</HTML>\n";
die;
                           
#-------------------------------------------------------------------
# Output an error page and die.
#-------------------------------------------------------------------
sub err {
   local ($errno) = @_;
   print "Content-type: text/html\n\n";
   print "<HTML>\n";
   print "<HEAD><TITLE>Errore</TITLE></HEAD>\n";
 # print "<HEAD><TITLE>Error</TITLE></HEAD>\n";
   print "<BODY BGCOLOR=\"#FFFFFF\">\n";
   print "<H1>Errore nella creazione dell'account</H1>\n";
 # print "<H1>Account creation error</H1>\n";
   print "<H3>" . $errmsg[$errno] . "</H3>" . "\n";
   print "Usare il pulsante del browser per tornare alla pagina precedente ed effettuare le correzioni.\n";
 # print "Click the Back button of your browser and make the correction.\n";
   print "</BODY>\n";
   print "</HTML>\n";
   die;
   }

#-------------------------------------------------------------------
# Decode a URL encoded string or array of strings 
# 1.      Change "+" to space, since FORMS change space to "+"
# 2.      Change "%XX" to character with hex value "XX"
#-------------------------------------------------------------------
sub UrlDecode {
   foreach (@_) {
      tr/+/ /;
      s/%(..)/pack("c",hex($1))/ge;
      }
   wantarray ? @_ : $_[$[];
   }

#-------------------------------------------------------------------
# Search a file for a regular expression (case-insensitive).
#-------------------------------------------------------------------
sub search {
   local($regexp, $file) = @_;
   open (INDATA, $file);
   while (<INDATA>) {
      /$regexp/i && return 1; }
   return 0;
   }
