#!/usr/bin/perl
#-------------------------------------------------------------------
# adduser.pl		CGI perl script to add an user to a Linux
#			box. It is supposed to be called by an
#			HTML form.
#
# Version		1.7	20 Mar 2000
#
# Author:		Niccolo Rigacci <rigacci@iname.com>
#-------------------------------------------------------------------

# This is a CGI-BIN...
print "Content-type: text/html\n\n";

# Initial login group (numeric, for Debian adduser).
$INITIAL_GROUP = '65534';

# User prototype for setting quota.
$QUOTA_PROTO_USER = 'mboxprot';

# Select language.
$LANG = 'us';

# Info shown after account creation.
$MAIL_DOMAIN = 'apinforma.com';
$MAIL_SERVER = 'mail.apinforma.com';
$WEB_SERVER  = 'http://mail.apinforma.com/';

# Maximum number of user allowed.
$MAX_USERS = 500;

# Where to write the log.
$LOG_FILE = '/var/log/adduser.cgi.log';

# Digits used to generate username: must be between 1 and 6.
$USERNAME_DIGITS = 3;

# Max input len (to avoid buffer overflow exploit?).
$MAX_INPUT_LEN = 255;

# Set the PATH for he shake of security.
$ENV{'PATH'} = '/sbin:/bin:/usr/sbin:/usr/bin';

# English messages.
if ($LANG eq 'us') { %ms = (
	'err_head',	'Error',
	'err_tit',	'Account creation error',
	'err_msg1',	'If you got a System error, please contact the administrator.',
	'err_msg2',	'Otherwise click the browser\'s Back button and correct your data.',
	'0',		'First name is not valid',
	'1',		'Last name is not valid',
	'2',		'E-mail alias is not valid',
	'3',		'E-mail alias already exists',
	'4',		'E-mail alias already exists as user',
	'5',		'Password is not valid',
	'6',		'Passwords don\'t match',
	'7',		'Can\'t generate unique username',
	'8',		'System error: maximum number of users reached',
	'9',		'System error: adduser',
	'10',		'System error: fork chpasswd',
	'11',		'System error: open aliases',
	'12',		'System error: edquota',
	'13',		'System error: open logfile',
	'res_head',	'Account creation',
	'res_tit1',	'Account created successfully',
	'res_tit2',	'Information to access the service',
	'res_username',	'Username           ',
	'res_password',	'Password           ',
	'res_comment',	'Comment            ',
	'res_email',	'E-mail address     ',
	'res_websrv',	'Internet address   ',
	'res_mailsrv',	'POP3/IMAP server   ',
	'res_time',	'Creation time      ',
	'res_IP',	'Your IP address    ',
	'res_msg1',	'Write down or print the information above.',
	'res_msg2',	'Without Username and Password you will be unable to access the service.',
	'res_do_login', 'Login now',
	'res_go_home',  'Back to the Home page',
)}
	
# Italian messages.
if ($LANG eq 'it') { %ms = (
	'err_head',	'Errore',
	'err_tit',	'Errore nella creazione dell\'account',
	'err_msg1',	'Se si tratta di un errore di sistema si prega di avvisare l\'amministratore.',
	'err_msg2',	'Altrimenti tornate alla pagina precedente ed effettuate le correzioni.',
	'0',		'Il nome non &egrave; valido',
	'1',		'Il cognome non &egrave; valido',
	'2',		'L\'indirizzo e-mail non &egrave; valido',
	'3',		'L\'indirizzo e-mail esiste gi&agrave;',
	'4',		'L\'indirizzo e-mail esiste gi&agrave; come utente',
	'5',		'La password non &egrave; valida',
	'6',		'Le password non coincidono',
	'7',		'Impossibile generare uno username univoco',
	'8',		'Errore di sistema: raggiunto il numero massimo di iscritti',
	'9',		'Errore di sistema: adduser',
	'10',		'Errore di sistema: fork chpasswd',
	'11',		'Errore di sistema: open aliases',
	'12',		'Errore di sistema: edquota',
	'13',		'Errore di sistema: open logfile',
	'res_head',	'Crezione account',
	'res_tit1',	'Account creato con successo',
	'res_tit2',	'Informazioni per accedere al servizio',
	'res_username',	'Username                  ',
	'res_password',	'Password                  ',
	'res_comment',	'Commento                  ',
	'res_email',	'Indirizzo e-mail          ',
	'res_websrv',	'Indirizzo Internet        ',
	'res_mailsrv',	'Server POP3/IMAP          ',
	'res_time',	'Ora di creazione          ',
	'res_IP',	'Indirizzo IP di origine   ',
	'res_msg1',	'Si consiglia di annotare o stampare le informazioni sopra riportate.',
	'res_msg2',	'In particolar modo Username e Password, senza le quali &egrave; impossibile accedere al servizio.',
	'res_do_login', 'Esegui il login adesso',
	'res_go_home',  'Torna alla Home page',
)}

#-------------------------------------------------------------------
# Preliminary check: put whatever you want here.
#-------------------------------------------------------------------
# I check that there aren't more than the allowed accounts.
&err(8) if `/bin/cat /etc/passwd | /usr/bin/wc -l` > $MAX_USERS;

#-------------------------------------------------------------------
# Read standard input and split it in an associative array.
#-------------------------------------------------------------------
# Determine input lenght and read it.
$i = $ENV{'CONTENT_LENGTH'};
$i = ($i > $MAX_INPUT_LEN) ? $MAX_INPUT_LEN : $i;
read(STDIN, $form, $i);
if ($form =~ /=/) {
   %form = &UrlDecode(split(/[&=]/, $form));}

#-------------------------------------------------------------------
# Check FIRSTNAME: 2 to 20 alphanum chars with spaces inside.
#-------------------------------------------------------------------
# Remove leading and trailing spaces.
$form{'FIRSTNAME'} =~ s/^ +//;
$form{'FIRSTNAME'} =~ s/ +$//;
&err(0) if !($form{'FIRSTNAME'} =~ /^[ \w\200-\377]{2,20}$/);

#-------------------------------------------------------------------
# Check LASTNAME: 2 to 20 alphanum chars with spaces inside.
#-------------------------------------------------------------------
# Remove leading and trailing spaces.
$form{'LASTNAME'} =~ s/^ +//;
$form{'LASTNAME'} =~ s/ +$//;
&err(1) if !($form{'LASTNAME'} =~ /^[ \w\200-\377]{2,20}$/);

#-------------------------------------------------------------------
# Check ALIAS.
#-------------------------------------------------------------------
# Remove leading and trailing spaces.
$form{'ALIAS'} =~ s/^ +//;
$form{'ALIAS'} =~ s/ +$//;

# Check for len between 1 and 20 chars.
&err(2) if !($form{'ALIAS'} =~ /^.{1,20}$/);

# Check for RFC822 compliance.
# An atom is any CHAR (0-127 ASCII) except SPACE, specials and
# CTLs (0-31 and 127 ASCII). See RFC822.
$atom = '^\ \(\)\<\>\@\,\;\:\\\"\.\[\]\000-\037\177-\377';
# This check is more restrictive than what is allowed by RFC822
# as the local-part for an e-mail address.
&err(2) if !($form{'ALIAS'} =~ /^[$atom]+(\.[$atom]+)*$/);

# Check if already exists as alias.
$regexp = '^\s*' . quotemeta($form{'ALIAS'}) . '\s*:';
&err(3) if &search($regexp, '/etc/aliases');

# Check if already exists as user.
$regexp = '^' . quotemeta($form{'ALIAS'}) . ':';
&err(4) if &search($regexp, '/etc/passwd');

#-------------------------------------------------------------------
# Check PASSWD.
#-------------------------------------------------------------------
# Check for len between 4 and 8 chars.
&err(5) if !($form{'PASSWD'} =~ /^.{4,8}$/);
&err(6) if ($form{'PASSWD'} ne $form{'PASSWD_CONFIRM'});

#-------------------------------------------------------------------
# Generate an unique username using initials plus a random number.
#-------------------------------------------------------------------
$try = 0;
$uniq = '';
# Try several times to generate a random unique username.
while ($try++ < (10 ** $USERNAME_DIGITS) && !$uniq) {
   $username = lc(substr($form{'FIRSTNAME'}, 0, 1)) .
      lc(substr($form{'LASTNAME'}, 0, 1)) .
      sprintf('%0' . $USERNAME_DIGITS . 'd',
      int(rand(10 ** $USERNAME_DIGITS)));
   $uniq = !(&search('^' . $username . ':', '/etc/passwd'));
   }
&err(7) if !$uniq;
# Make gecos from first and last name.
$gecos = $form{'FIRSTNAME'} . " " . $form{'LASTNAME'};

#-------------------------------------------------------------------
# Create the account (the script must be run by root).
#-------------------------------------------------------------------
$timestamp = localtime();
$ipaddress = $ENV{'REMOTE_ADDR'};
open (LOG, ">> $LOG_FILE") || err(13);
print LOG '--- ', $timestamp, ' --- Adding user from IP ', $ipaddress, "\n";
close (LOG);

#-------------------------------------------------------------------
# Add the user to the system (use Debian adduser).
#-------------------------------------------------------------------
# Security: user's variables $gecos and $username should be safe...
$i = system ("/usr/sbin/adduser --disabled-password --gid $INITIAL_GROUP --gecos \"$gecos\" $username >> $LOG_FILE 2>&1");
&err(9) if ($i != 0);
# Set the shell to /bin/false, to prevent shell login.
# Can't trap chsh errors, can't redirect output: why?
system ("/usr/bin/chsh -s /bin/false $username");
#-------------------------------------------------------------------
# Set the password. For security do it without executing a shell!
#-------------------------------------------------------------------
# Fork a perl process; the child execs chpasswd.
my $result = open (CHPASSWD, "|-"); err(10) unless defined($result);
exec '/usr/sbin/chpasswd' if $result == 0;
# The parent sends the input to the child.
print CHPASSWD "$username", ':', "$form{'PASSWD'}", "\n";
close (CHPASSWD);
#-------------------------------------------------------------------
# Add the alias.
#-------------------------------------------------------------------
open (ALIASES, '>> /etc/aliases') || err(11);
print ALIASES "$form{'ALIAS'}", ': ', "$username", "\n";
close (ALIASES);
#-------------------------------------------------------------------
# Activate quota for the user.
#-------------------------------------------------------------------
$i = system ("/usr/sbin/edquota -p $QUOTA_PROTO_USER -u $username >> $LOG_FILE 2>&1");
&err(12) if ($i != 0);

#-------------------------------------------------------------------
# Update log with new account data.
#-------------------------------------------------------------------
open (LOG, ">> $LOG_FILE") || err(13);
print LOG '### ';
print LOG $username, ",";
print LOG $gecos, ",";
print LOG $form{'ALIAS'}, ",";
print LOG $timestamp, ",";
print LOG $ipaddress, "\n";
close (LOG);

#-------------------------------------------------------------------
# Output the result.
#-------------------------------------------------------------------
print "<HTML>\n";
print "<HEAD><TITLE>" . $ms{'res_head'} . "</TITLE></HEAD>\n";
print "<BODY BGCOLOR=\"#FFFFF0\">\n";
print "<H1>" . $ms{'res_tit1'} . "</H1>\n";
print "<HR>\n";
print "<H3>" . $ms{'res_tit2'} . "</H3>\n";
print "<PRE>\n";
print $ms{'res_username'} . $username       . "\n";
print $ms{'res_password'} . $form{'PASSWD'} . "\n";
print $ms{'res_comment'}  . $gecos          . "\n";
print $ms{'res_email'}    . $form{'ALIAS'}  . '@' . $MAIL_DOMAIN . "\n";
print $ms{'res_websrv'}   . $WEB_SERVER     . "\n";
print $ms{'res_mailsrv'}  . $MAIL_SERVER    . "\n";
print "\n";
print $ms{'res_time'}     . $timestamp . "\n";
print $ms{'res_IP'}       . $ipaddress . "\n";
print "</PRE>\n";
print $ms{'res_msg1'} . "<BR>\n";
print $ms{'res_msg2'} . "\n";
print "<HR>\n";
print "<A HREF=\"/imp/\">" . $ms{'res_do_login'} . "</A><BR>\n";
print "<A HREF=\"/\">"     . $ms{'res_go_home'}  . "</A>\n";
print "</BODY>\n";
print "</HTML>\n";
die;
                           
#-------------------------------------------------------------------
# Output an error page and die.
#-------------------------------------------------------------------
sub err {
   local ($errno) = @_;
   print "<HTML>\n";
   print "<HEAD><TITLE>" . $ms{'err_head'} . "</TITLE></HEAD>\n";
   print "<BODY BGCOLOR=\"#FFFFF0\">\n";
   print "<H1>" . $ms{'err_tit'} . "</H1>\n";
   print "<H3>" . $ms{$errno} . "</H3>" . "\n";
   print $ms{'err_msg1'} . "<BR>\n";
   print $ms{'err_msg2'} . "\n";
   print "</BODY>\n";
   print "</HTML>\n";
   die;
   }

#-------------------------------------------------------------------
# Decode a URL encoded string or array of strings 
# 1.      Change "+" to space, since FORMS change space to "+"
# 2.      Change "%XX" to character with hex value "XX"
#-------------------------------------------------------------------
sub UrlDecode {
   foreach (@_) {
      tr/+/ /;
      s/%(..)/pack("c",hex($1))/ge;
      }
   wantarray ? @_ : $_[$[];
   }

#-------------------------------------------------------------------
# Search a file for a regular expression (case-insensitive).
#-------------------------------------------------------------------
sub search {
   local($regexp, $file) = @_;
   $found = 0;
   open (INDATA, $file);
   while (<INDATA>) {
      last if (/$regexp/i && ($found = 1)) }
   close (INDATA);
   return $found;
   }
