#!/usr/bin/perl
#-------------------------------------------------------------------
# chuser.pl		Cgi-bin to change user account.
#
# Version		0.2	28 Mar 2000
#
# Author:		Niccolo Rigacci <rigacci@iname.com>
#
# Copyright (C) 2000 Niccolo Rigacci
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#-------------------------------------------------------------------

# This is a CGI-BIN...
print "Content-type: text/html\n\n";

# Group owning the .forward file.
$GROUP = 'mbox';

# Select the language.
$LANG = 'us';

# Where to write the log.
$LOG_FILE = '/var/log/chuser.log';

# Max input len (to avoid buffer overflow?).
$MAX_INPUT_LEN = 255;

# Set the PATH for the shake of security.
$ENV{'PATH'} = '/sbin:/bin:/usr/sbin:/usr/bin';

# English messages.
if ($LANG eq 'us') { %ms = (
	'err_head',	'Error',
	'err_title',	'Error changing account information',
	'err_msg1',     'If you got a System error, please contact the administrator.',
	'err_msg2',     'Otherwise click the browser\'s Back button and correct your data.',
	'ERR_BAD_USR',	'Access denied (user unknown)',
	'ERR_BAD_PWD',	'Access denied (bad password)',
	'ERR_BAD_NEW',	'New password is not valid',
	'ERR_MISMATCH',	'New password does not match confirm',
	'ERR_BAD_FWD',	'Forward address not allowed',
	'ERR_CHPASSWD',	'System error: fork chpasswd',
	'ERR_OPEN_FWD',	'System error: open .forward',
	'ERR_OPEN_LOG',	'System error: open logfile',
	'res_head',	'Account change',
	'res_tit1',	'Account changed successfuly',
	'res_tit2',	'Canges summary',
	'res_login',	'Username          ',
	'res_passwd',	'Password          ',
	'res_forward',	'Mail forwarding   ',
	'res_time',	'Changes time      ',
	'res_IP',	'Your IP address   ',
	'res_msg1',	'Write down or print the information above.',
	'res_msg2',	'Without your password, you will be unable to access the service.',
	'res_do_login',	'Login now',
	'res_go_home',	'Back to the Home page',
	'unchanged',	'(Unchanged)',
	'disabled',	'(Disabled)',
)}

# Italian messages.
if ($LANG eq 'it') { %ms = (
	'err_head',	'Errore',
	'err_title',	'Errore nella modifica dell\'account',
	'err_msg1',     'Se si tratta di un errore di sistema si prega di avvisare l\'amministratore.',
	'err_msg2',     'Altrimenti tornate alla pagina precedente ed effettuate le correzioni.',
	'ERR_BAD_USR',	'Accesso negato (utente sconosciuto)',
	'ERR_BAD_PWD',	'Accesso negato (password sbagliata)',
	'ERR_BAD_NEW',	'La nuova password non &egrave; valida',
	'ERR_MISMATCH',	'La conferma della nuova password non coincide',
	'ERR_BAD_FWD',	'L\'indirizzo per il forward non &egrave; consentito',
	'ERR_CHPASSWD',	'Errore di sistema: fork chpasswd',
	'ERR_OPEN_FWD',	'Errore di sistema: open .forward',
	'ERR_OPEN_LOG',	'Errore di sistema: open logfile',
	'res_head',	'Modifica account',
	'res_tit1',	'Account modificato con successo',
	'res_tit2',	'Riepilogo modifiche',
	'res_login',	'Username                  ',
	'res_passwd',	'Password                  ',
	'res_forward',	'Inoltro posta (forward)   ',
	'res_time',	'Ora della modifica        ',
	'res_IP',	'Indirizzo IP di origine   ',
	'res_msg1',	'Si consiglia di annotare o stampare le informazioni sopra riportate.',
	'res_msg2',	'In particolar modo la Password, senza la quale &egrave; impossibile accedere al servizio.',
	'res_do_login',	'Esegui il login adesso',
	'res_go_home',	'Torna alla Home page',
	'unchanged',	'(Nessuna modifica)',
	'disabled',	'(Disabilitato)',
)}

#-------------------------------------------------------------------
# Read standard input and split it in an associative array.
#-------------------------------------------------------------------
# Determine input lenght and read it.
$i = $ENV{'CONTENT_LENGTH'};
$i = ($i > $MAX_INPUT_LEN) ? $MAX_INPUT_LEN : $i;
read(STDIN, $form, $i);
if ($form =~ /=/) {
   %form = &UrlDecode(split(/[&=]/, $form));}

#-------------------------------------------------------------------
# Check if NEW_PASSWD matches with NEW_PASSWD_CONFIRM.
#-------------------------------------------------------------------
# Check for len between 4 and 8 chars.
if ($form{'NEW_PASSWD'} ne '') {
   &err('ERR_BAD_NEW') if !($form{'NEW_PASSWD'} =~ /^.{4,8}$/);
   &err('ERR_MISMATCH') if ($form{'NEW_PASSWD'} ne $form{'NEW_PASSWD_CONFIRM'});
   }

#-------------------------------------------------------------------
# Check if FORWARD is acceptable.
#-------------------------------------------------------------------
if (($form{'ENABLE_FORWARD'} ne '') && ($form{'FORWARD'} ne '')) {
   # Remove leading and trailing spaces.
   $form{'FORWARD'} =~ s/^ +//;
   $form{'FORWARD'} =~ s/ +$//;
   # Check for len between 1 and 35 chars.
   &err('ERR_BAD_FWD') if !($form{'FORWARD'} =~ /^[\w\@\.-]{1,35}$/);
   }

#-------------------------------------------------------------------
# Start logging info.
#-------------------------------------------------------------------
$ipaddress = $ENV{'REMOTE_ADDR'};
$timestamp = localtime();
open (LOG, ">> $LOG_FILE") || err('ERR_OPEN_LOG');
print LOG '--- ', $timestamp, ' --- Changing account from IP ', $ipaddress, "\n";
close (LOG);

#-------------------------------------------------------------------
# Check USERNAME and PASSWD.
#-------------------------------------------------------------------
$regexp = '^' . quotemeta($form{'USERNAME'}) . ':';
# Search username in /etc/passwd.
$passwd_row = '';
open (FILE, '/etc/passwd');
while (<FILE>) {
   last if (/$regexp/i && ($passwd_row = $_)) }
close (FILE);
&err('ERR_BAD_USR') if ($passwd_row eq '');
# Search username in /etc/shadow.
$shadow_row = '';
open (FILE, '/etc/shadow');
while (<FILE>) {
   last if (/$regexp/i && ($shadow_row = $_)) }
close (FILE);
&err('ERR_BAD_USR') if ($shadow_row eq '');
# Split passwd and shadow rows in components.
@passwd_item = split(/:/, $passwd_row);
@shadow_item = split(/:/, $shadow_row);
# Check if system password matches the one given.
&err('ERR_BAD_PWD') if ($shadow_item[1] ne $form{'CRYPT_PASSWD'});

#-------------------------------------------------------------------
# Change password. For security do it without executing a shell!
#-------------------------------------------------------------------
$newpasswd = $ms{'unchanged'};
if ($form{'NEW_PASSWD'} ne '') {
   # Fork a perl process; the child execs chpasswd.
   my $result = open (CHPASSWD, "|-"); err(ERR_CHPASSWD) unless defined($result);
   exec '/usr/sbin/chpasswd' if $result == 0;
   # The parent sends the input to the child.
   print CHPASSWD "$form{'USERNAME'}", ':', "$form{'NEW_PASSWD'}", "\n";
   close (CHPASSWD);
   $newpasswd = "$form{'NEW_PASSWD'}";
   }

#-------------------------------------------------------------------
# Change .forward in user's home directory as required.
#-------------------------------------------------------------------
# Remove .forward if check is unchecked or field is blank.
if (($form{'ENABLE_FORWARD'} eq '') || ($form{'FORWARD'} eq '')) {
   unlink ("$passwd_item[5]/.forward");
   $forwarding = $ms{'disabled'};
   }
else {
   open (FWD, "> $passwd_item[5]/.forward") || err(ERR_OPEN_FWD);
   print FWD "$form{'FORWARD'}";
   close (FWD);
   system ("/bin/chown $form{'USERNAME'} $passwd_item[5]/.forward  >> $LOG_FILE 2>&1");
   system ("/bin/chgrp $GROUP $passwd_item[5]/.forward  >> $LOG_FILE 2>&1");
   $forwarding = "$form{'FORWARD'}";
   }

#-------------------------------------------------------------------
# Update log with new account data.
#-------------------------------------------------------------------
$timestamp = localtime();
open (LOG, ">> $LOG_FILE") || err('ERR_OPEN_LOG');
print LOG '--- ', $timestamp, ' --- Account changed: ';
print LOG $form{'USERNAME'}, ",";
print LOG $forwarding, ",";
print LOG $ipaddress, "\n";
close (LOG);

#-------------------------------------------------------------------
# Output the result.
#-------------------------------------------------------------------
print "<HTML>\n";
print "<HEAD><TITLE>" . $ms{'res_head'} . "</TITLE></HEAD>\n";
print "<BODY BGCOLOR=\"#FFFFF0\">\n";
print "<H1>" . $ms{'res_tit1'} . "</H1>\n";
print "<HR>\n";
print "<H3>" . $ms{'res_tit2'} . "</H3>\n";
print "<PRE>\n";
print $ms{'res_login'}   . $form{'USERNAME'} . "\n";
print $ms{'res_passwd'}  . $newpasswd     . "\n";
print $ms{'res_forward'} . $forwarding    . "\n";
print "\n";
print $ms{'res_time'}    . $timestamp     . "\n";
print $ms{'res_IP'}      . $ipaddress     . "\n";
print "</PRE>\n";
print $ms{'res_msg1'} . "<BR>\n";
print $ms{'res_msg2'} . "\n";
print "<HR>\n";
print "<A HREF=\"/imp/\">" . $ms{'res_do_login'} . "</A><BR>\n";
print "<A HREF=\"/\">"     . $ms{'res_go_home'}  . "</A>\n";
print "</BODY>\n";
print "</HTML>\n";
die;
                           
#-------------------------------------------------------------------
# Output an error page and die.
#-------------------------------------------------------------------
sub err {
   local ($errno) = @_;
   print "<HTML>\n";
   print "<HEAD><TITLE>" . $ms{'err_head'} . "</TITLE></HEAD>\n";
   print "<BODY BGCOLOR=\"#FFFFF0\">\n";
   print "<H1>" . $ms{'err_title'} . "</H1>\n";
   print "<H3>" . $ms{$errno} . "</H3>" . "\n";
   print $ms{'err_msg1'} . "<BR>\n";
   print $ms{'err_msg2'} . "\n";
   print "</BODY>\n";
   print "</HTML>\n";
   die;
   }

#-------------------------------------------------------------------
# Decode a URL encoded string or array of strings 
# 1.      Change "+" to space, since FORMS change space to "+"
# 2.      Change "%XX" to character with hex value "XX"
#-------------------------------------------------------------------
sub UrlDecode {
   foreach (@_) {
      tr/+/ /;
      s/%(..)/pack("c",hex($1))/ge;
      }
   wantarray ? @_ : $_[$[];
   }
