#!/usr/bin/perl
#-------------------------------------------------------------------
# chuser_form.pl	Cgi-bin, build the form for calling chuser.
#
# Version		0.2	28 Mar 2000
#
# Author:		Niccolo Rigacci <rigacci@iname.com>
#
# Copyright (C) 2000 Niccolo Rigacci
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#-------------------------------------------------------------------

# This is a CGI-BIN...
print "Content-type: text/html\n\n";

# Device where to get quota info, leave it blank if quota is not enabled.
# $QUOTA_DEV = '';
$QUOTA_DEV = '/dev/hda2';

# Used to show actual e-mail address.
$MAIL_DOMAIN = 'apinforma.com';

# Select the language.
$LANG = 'us';

# Where to write the log.
$LOG_FILE = '/var/log/chuser.log';

# Max input len (to avoid buffer overflow?).
$MAX_INPUT_LEN = 255;

# Set the PATH for the shake of security.
$ENV{'PATH'} = '/sbin:/bin:/usr/sbin:/usr/bin';

# English messages.
if ($LANG eq 'us') { %ms = (
	'err_head',	'Error',
	'err_tit',	'Unable to get account information',
	'err_msg1',     'If you got a System error, please contact the administrator.',
	'err_msg2',     'Otherwise click the browser\'s Back button and correct your data.',
	'ERR_USR',	'Access denied (user unknown)',
	'ERR_PWD',	'Access denied (bad password)',
	'ERR_LOG',	'System error: open logfile',
	'frm_head',	'Account change',
	'frm_tit1',	'Account change',
	'frm_username',	'Username:',
	'frm_comment',	'Comment:',
	'frm_quota',	'Space used:',
	'frm_alias',	'E-mail address:',
	'frm_newpass',	'New password:',
	'frm_leave',	'(leave it blank if you want<BR>your password unchanged)',
	'frm_confirm',	'Confirm new password:',
	'frm_forward',	'Enable mail forward:',
	'frm_fwdto',	'Forward mail to:',
	'frm_submit',	'Submit',
)}

# Italian messages.
if ($LANG eq 'it') { %ms = (
	'err_head',	'Errore',
	'err_tit',	'Impossibile accedere all\'account',
	'err_msg1',     'Se si tratta di un errore di sistema si prega di avvisare l\'amministratore.',
	'err_msg2',     'Altrimenti tornate alla pagina precedente ed effettuate le correzioni.',
	'ERR_USR',	'Accesso negato (utente sconosciuto)',
	'ERR_PWD',	'Accesso negato (password sbagliata)',
	'ERR_LOG',	'Errore di sistema: open logfile',
	'frm_head',	'Modifica account',
	'frm_tit1',	'Modifica account',
	'frm_username',	'Username:',
	'frm_comment',	'Commento:',
	'frm_quota',	'Spazio utilizzato:',
	'frm_alias',	'Indirizzo posta elettronica:',
	'frm_newpass',	'Nuova password:',
	'frm_leave',	'(lasciare in bianco per<BR>non cambiarla)',
	'frm_confirm',	'Conferma password:',
	'frm_forward',	'Abilita inoltro posta (forward):',
	'frm_fwdto',	'Inoltra posta a:',
	'frm_submit',	'Esegui',
)}

#-------------------------------------------------------------------
# Read standard input and split it in an associative array.
#-------------------------------------------------------------------
# Determine input lenght and read it.
$i = $ENV{'CONTENT_LENGTH'};
$i = ($i > $MAX_INPUT_LEN) ? $MAX_INPUT_LEN : $i;
read(STDIN, $form, $i);
if ($form =~ /=/) {
   %form = &UrlDecode(split(/[&=]/, $form));}

#-------------------------------------------------------------------
# Log some info.
#-------------------------------------------------------------------
$ipaddress = $ENV{'REMOTE_ADDR'};
$timestamp = localtime();
open (LOG, ">> $LOG_FILE") || err('ERR_LOG');
print LOG '--- ', $timestamp, ' --- Getting info for user ', $form{'USERNAME'}, ' from IP ', $ipaddress, "\n";
close (LOG);

#-------------------------------------------------------------------
# Check USERNAME and PASSWD.
#-------------------------------------------------------------------
$regexp = '^' . quotemeta($form{'USERNAME'}) . ':';
# Search username in /etc/passwd.
$passwd_row = '';
open (INDATA, '/etc/passwd');
while (<INDATA>) {
   last if (/$regexp/i && ($passwd_row = $_)) }
close (INDATA);
&err('ERR_USR') if ($passwd_row eq '');
# Search username in /etc/shadow.
$shadow_row = '';
open (INDATA, '/etc/shadow');
while (<INDATA>) {
   last if (/$regexp/i && ($shadow_row = $_)) }
close (INDATA);
&err('ERR_USR') if ($shadow_row eq '');
# Split passwd and shadow rows in components.
@passwd_item = split(/:/, $passwd_row);
@shadow_item = split(/:/, $shadow_row);
# Split gecos field in components.
@gecos_item = split(/,/, $passwd_item[4]);
# Check if system password matches the one given.
&err('ERR_PWD') if ($shadow_item[1] ne
   crypt($form{'PASSWD'}, substr($shadow_item[1], 0, 2)));

#-------------------------------------------------------------------
# Log additional info.
#-------------------------------------------------------------------
$timestamp = localtime();
open (LOG, ">> $LOG_FILE") || err('ERR_LOG');
print LOG '--- ', $timestamp, ' --- Username and password check passed', "\n";
close (LOG);

#-------------------------------------------------------------------
# Read .forward in user's home.
#-------------------------------------------------------------------
if (open (FWD, "< $passwd_item[5]/.forward")) {
   read (FWD, $forward, 35);
   close (FWD);
   # Remove trailing newline.
   $forward =~ s/\n//;
   $checked = 'CHECKED';
   }
else {
   $forward = '';
   $checked = '';
   }
   
#-------------------------------------------------------------------
# Get quota information.
#-------------------------------------------------------------------
if ($QUOTA_DEV ne '') {
   # Exec quota command and capture output in a list.
   @tmp = `/usr/bin/quota $form{'USERNAME'}`;
   # Search the line referring to quoted file system.
   $dev = quotemeta($QUOTA_DEV);
   @line = grep(/^ +$dev/, @tmp);
   # Remove leading and repeated spaces.
   $line[0] =~ s/^ *//;
   $line[0] =~ s/ +/ /g;
   # Split in space separated fields.
   @quota_item = split(/ /, $line[0]);
   }

#-------------------------------------------------------------------
# Get e-mail alias.
#-------------------------------------------------------------------
$regexp = ':\s*' . quotemeta($form{'USERNAME'}). '\s*$';
open (INDATA, '/etc/aliases');
while (<INDATA>) {
   last if (/$regexp/i && ($alias = $_)) }
close (INDATA);
$alias =~ s/\n//;
$alias =~ s/:\s*\S+$//;

#-------------------------------------------------------------------
# Output the resulting form.
#-------------------------------------------------------------------
print "<HTML>\n\n";
print "<HEAD><TITLE>" . $ms{'frm_head'} . "</TITLE></HEAD>\n\n";

print "<BODY BGCOLOR=\"#FFFFF0\">\n\n";

print "<H1>" . $ms{'frm_tit1'} . "</H1>\n\n";

print "<FORM ACTION=\"/cgi-bin/chuser\" METHOD=\"post\">\n\n";

print "<INPUT TYPE=\"hidden\" NAME=\"USERNAME\" MAXLENGTH=\"20\" VALUE=\"" . $form{'USERNAME'} . "\">\n";
print "<INPUT TYPE=\"hidden\" NAME=\"CRYPT_PASSWD\" MAXLENGTH=\"8\" VALUE=\"" . $shadow_item[1] . "\">\n\n";

print "<TABLE>\n\n";

print "<TR>\n";
print "<TD><B>" . $ms{'frm_username'} . "</B></TD>\n";
print "<TD><B>" . $form{'USERNAME'} . "</B></TD>\n";
print "</TR>\n\n";

print "<TR>\n";
print "<TD><B>" . $ms{'frm_comment'} . "</B></TD>\n";
print "<TD><B>" . $gecos_item[0] . "</B></TD>\n";
print "</TR>\n\n";

if ($QUOTA_DEV ne '') {
   print "<TR>\n";
   print "<TD><B>" . $ms{'frm_quota'} . "</B></TD>\n";
   print "<TD><B>" . $quota_item[1] . " / " . $quota_item[2] . " kb</B></TD>\n";
   print "</TR>\n\n";
   }

print "<TR>\n";
print "<TD><B>" . $ms{'frm_alias'} . "</B></TD>\n";
print "<TD><B>" . $alias . "@" . $MAIL_DOMAIN . "</B></TD>\n";
print "</TR>\n\n";

print "<TR><TD><HR></TD><TD><HR></TD></TR>\n\n";

print "<TR>\n";
print "<TD><B>" . $ms{'frm_newpass'} . "</B><BR>\n";
print "<SMALL>" . $ms{'frm_leave'} . "</SMALL></TD>\n";
print "<TD><INPUT TYPE=\"password\" NAME=\"NEW_PASSWD\" MAXLENGTH=\"8\"></TD>\n";
print "</TR>\n\n";

print "<TR>\n";
print "<TD><B>" . $ms{'frm_confirm'} . "</B></TD>\n";
print "<TD><INPUT TYPE=\"password\" NAME=\"NEW_PASSWD_CONFIRM\" MAXLENGTH=\"8\"></TD>\n";
print "</TR>\n\n";

print "<TR><TD><HR></TD><TD><HR></TD></TR>\n\n";

print "<TR>\n";
print "<TD><B>" . $ms{'frm_forward'} . "</B></TD>\n";
print "<TD><INPUT TYPE=\"checkbox\" NAME=\"ENABLE_FORWARD\" VALUE=\"on\" " . $checked . "></TD>\n";
print "</TR>\n\n";

print "<TR>\n";
print "<TD><B>" . $ms{'frm_fwdto'} . "</B></TD>\n";
print "<TD><INPUT TYPE=\"text\" NAME=\"FORWARD\" MAXLENGTH=\"35\" SIZE=\"30\" VALUE=\"" . $forward . "\"></TD>\n";
print "</TR>\n\n";

print "<TR>\n";
print "<TD>&nbsp;</TD>\n";
print "<TD><INPUT TYPE=\"submit\" VALUE=\"" . $ms{'frm_submit'} . "\"></TD>\n";
print "</TR>\n\n";

print "</TABLE>\n";
print "</FORM>\n\n";

print "</BODY>\n";
print "</HTML>\n";
die;
                           
#-------------------------------------------------------------------
# Output an error page and die.
#-------------------------------------------------------------------
sub err {
   local ($errno) = @_;
   print "<HTML>\n";
   print "<HEAD><TITLE>" . $ms{'err_head'} . "</TITLE></HEAD>\n";
   print "<BODY BGCOLOR=\"#FFFFF0\">\n";
   print "<H1>" . $ms{'err_tit'} . "</H1>\n";
   print "<H3>" . $ms{$errno} . "</H3>" . "\n";
   print $ms{'err_msg1'} . "<BR>\n";
   print $ms{'err_msg2'} . "\n";
   print "</BODY>\n";
   print "</HTML>\n";
   die;
   }

#-------------------------------------------------------------------
# Decode a URL encoded string or array of strings 
# 1.      Change "+" to space, since FORMS change space to "+"
# 2.      Change "%XX" to character with hex value "XX"
#-------------------------------------------------------------------
sub UrlDecode {
   foreach (@_) {
      tr/+/ /;
      s/%(..)/pack("c",hex($1))/ge;
      }
   wantarray ? @_ : $_[$[];
   }
