Attribute VB_Name = "Module1"
'Costanti globali.
Global Const Glb_AppName = "Swatch"   'Application name.
Global Const FileTemp = "Disktmp.~sw"   'Nome per file temporaneo.
Global Const TempExt = ".~sw"           'Estensione per file immagine.
Global Const DirHead = "Directory of "  'Intestazione di una directory.
Global Const DirSig = "<DIR>"           'Flag di directory.

'Variabili globali.
Global ProgramDir$                      'Direcotry di default ("C:\" o "C:\SUBDIR").

'Variables from the Registry.
Global DefRunDrive$                     'Default "Run" drive (es. "A:").
Global Editor$                          'Es. "Notepad.exe".
Global KeepImageFiles%                  'True or False.
Global DisksToWatch$                    'Dischi da fotografare (es. "CDE")
Global Glb_IgnoreFoldersN%
Global Glb_IgnoreFilesN%
Global Glb_ScanFilesN%
Global Glb_IgnoreFolder$()
Global Glb_IgnoreFile$()
Global Glb_ScanFile$()

Function NormPath$(a$)
    '--------------------------------------------------------------------
    'Normalize the path a$, lowercasing it and removing
    'trailing "\". This is necessary to compare
    'paths, otherwise "C:\New Folder\" will be greather
    'than "C:\New Folder (2)\"
    '--------------------------------------------------------------------
    b$ = LCase$(a$)
    If Right$(b$, 1) = "\" Then b$ = Left$(b$, Len(b$) - 1)
    NormPath$ = b$
End Function

Function BinSearch%(m$(), Last%, Key$)
    '--------------------------------------------------------------------
    'Binary search the m$(1 To Last%) array for Key$.
    'Do a case-insensitive search. Return True or False.
    '--------------------------------------------------------------------
    l% = 1
    r% = Last%
    While r% >= l%
        x% = (l% + r%) \ 2
        If LCase$(m$(x%)) = LCase$(Key$) Then
            BinSearch% = True
            Exit Function
        End If
        If LCase$(Key$) < LCase$(m$(x%)) Then
            r% = x% - 1
        Else
            l% = x% + 1
        End If
    Wend
    BinSearch% = False
End Function

Function SearchPath%(m$(), Last%, Key$)
    '--------------------------------------------------------------------
    'Binary search the m$(1 To Last%) array for Key$.
    'Do a case-insensitive search. Return True or False.
    'The comparision is made on the left part of Key$ if the item m$(i%)
    'is shorter. So Key$ "C:\Windows\System\" matches with "C:\Windows\".
    '--------------------------------------------------------------------
    l% = 1
    r% = Last%
    While r% >= l%
        x% = (l% + r%) \ 2
        If LCase$(m$(x%)) = LCase$(Left$(Key$, Len(m$(x%)))) Then
            SearchPath% = True
            Exit Function
        End If
        If LCase$(Key$) < LCase$(m$(x%)) Then
            r% = x% - 1
        Else
            l% = x% + 1
        End If
    Wend
    SearchPath% = False
End Function

Function CutFileName$(a$)
    '--------------------------------------------------------------------
    'Search a pair of double quotes in a$ and return the text enclosed.
    'If not double quotes found, return a$ itself.
    '--------------------------------------------------------------------
    i% = InStr(a$, Chr$(34))
    j% = InStr(i% + 1, a$, Chr$(34))
    If i% = 0 Or j% = 0 Then
        CutFileName$ = a$
    Else
        CutFileName$ = Mid$(a$, i% + 1, j% - i% - 1)
    End If
End Function

Function AddBackslash$(a$)
   '--------------------------------------------------------------------
   'Ritorna a$ con un "\" finale, se non c' gi.
   '--------------------------------------------------------------------
   If Right$(a$, 1) <> "\" Then
      AddBackslash$ = a$ & "\"
   Else
      AddBackslash$ = a$
   End If
End Function

Sub CompareFile(FileSav$, FileNow$)
    '-------------------------------------------------------------------
    'Confronta FileSav$ con FileNow$ una riga per volta e scrive (su #1)
    'prima tutte le righe di FileSav$ non trovate in FileNow$
    'e poi il viceversa.
    '-------------------------------------------------------------------
    Dim WorkSpc$()

    'Read actual file in WorkSpc$() and count lines.
    LineCount% = 0
    f2% = FreeFile
    Open FileNow$ For Input As #f2%
    While Not EOF(f2%)
        LineCount% = LineCount% + 1
        ReDim Preserve WorkSpc$(1 To LineCount%)
        Line Input #f2%, WorkSpc$(LineCount%)
    Wend
    Close #f2%
    'Let space for inserting the sentinel.
    LineCount% = LineCount% + 1
    ReDim Preserve WorkSpc$(1 To LineCount%)

    'Open saved file.
    f2% = FreeFile
    Open FileSav$ For Input As #f2%
    'Counter for line in saved file.
    ps% = 0
    StampareIntestazione% = True
    While Not EOF(f2%)
        ps% = ps% + 1
        Line Input #f2%, Sav$
        If Sav$ <> "" Then
            'Search in WorkSpc$() the saved line.
            'Effettua una ricerca con sentinella.
            WorkSpc$(LineCount%) = Sav$
            i% = 1
            While Sav$ <> WorkSpc$(i%)
                i% = i% + 1
            Wend
            If i% = LineCount% Then
                'Saved line not found in actual file.
                If StampareIntestazione% Then
                    Print #1, HeadLine$("Removed Line from " & FileNow$)
                    StampareIntestazione% = False
                End If
                Print #1, Format$(ps%, "@@@  "); Sav$
            Else
                'Line exists in both files, remove it.
                WorkSpc$(i%) = ""
            End If
        End If
    Wend
    Close #f2%

    StampareIntestazione% = True
    For i% = 1 To LineCount% - 1
        If WorkSpc$(i%) <> "" Then
            If StampareIntestazione% Then
                Print #1, HeadLine$("Added Line to " & FileNow$)
                StampareIntestazione% = False
            End If
            Print #1, Format$(i%, "@@@  "); WorkSpc$(i%)
        End If
    Next i%
End Sub

Function Exist(FileSpec$) As Integer
   '------------------------------------------------
   'Ritorna True se FileSpec$ esiste, False altrimenti.
   '------------------------------------------------
   On Error Resume Next
   l = FileLen(FileSpec$)
   If Err Then
      Exist = False
   Else
      Exist = True
   End If
   On Error GoTo 0
End Function

Function ExistSet%()
   '------------------------------------------------------------------------
   'Controlla se esiste un set di dati salvati compatibile con i dati
   'Specificati nel dialog box di configurazione.
   '------------------------------------------------------------------------
   ExistSet% = True
   'Verifica l'esistenza delle immagini-disco.
   For i% = 1 To Len(DisksToWatch$)
      If Not Exist(Mid$(DisksToWatch$, i%, 1) & TempExt) Then
         ExistSet% = False
         Exit Function
      End If
   Next i%
   'Verifica l'esistenza dei file salvati.
   For i% = 1 To Glb_ScanFilesN%
      If Not Exist(Format$(i%) & TempExt) Then
         ExistSet% = False
         Exit Function
      End If
   Next i%
End Function

Sub ExtDir(StartDir$, FileOut$)
   '------------------------------------------------------------------
   'Crea un file di nome FileOut$ e vi scrive la directory specificata
   'in StartDir$ includendo le sottodirecotry e i file con qualsiasi
   'attributo; il tutto in ordine alfabetico.
   '------------------------------------------------------------------
   If Mid$(StartDir$, 2, 2) <> ":\" Then Exit Sub
   
   f% = FreeFile
   Open FileOut$ For Output As #f%
   XdirBox.Show
   Screen.MousePointer = 11

   Nodo$ = StartDir$
   If Right$(Nodo$, 1) <> "\" Then Nodo$ = Nodo$ & "\"

   Visita Nodo$, f%

   Close #f%
   Screen.MousePointer = 0
   Unload XdirBox
End Sub

Function GetNextDir(f%) As String
   '-------------------------------------------------------------
   'Legge il file (aperto con #f%) contenente la struttura
   'salvata dalla Sub ExtDir. Restituisce il nome della
   'directory successiva completo di path e backslash finale
   '(es. "C:\UTILITY\" oppure "C:\").
   'Se non trova altre directory ( stata raggiunta la fine di #f%)
   'allora restituisce CHR$(255).
   'Ignore folders in Glb_IgnoreFolder$().
   '-------------------------------------------------------------
    l% = Len(DirHead)
    Do
        If EOF(f%) Then
            GetNextDir = Chr$(255)
            Exit Function
        End If
        Line Input #f%, a$
    Loop While Left$(a$, l%) <> DirHead
    a$ = CutFileName$(a$)
    'Check if the folder must be ignored.
    If SearchPath%(Glb_IgnoreFolder$(), Glb_IgnoreFoldersN%, a$) Then
        GetNextDir = GetNextDir(f%)
    Else
        GetNextDir = a$
    End If
End Function

Function GetNextFile(f%) As String
   '-------------------------------------------------------------
   'Legge il file (aperto con #f%) contenente la directory
   'salvata dalla Sub ExtDir. Restituisce il nome del
   'file successivo completo delle informazioni  Size, Date, Time.
   'Se non trova altri nomi ( stata raggiunta la fine di #f%
   'oppure si trova una riga vuota) allora restiruisce CHR$(255).
   '-------------------------------------------------------------
   l% = Len(DirSig)
   Do
      If EOF(f%) Then
         GetNextFile = Chr$(255)
         Exit Function
      End If
      Line Input #f%, a$

      If a$ = "" Then
         GetNextFile = Chr$(255)
         Exit Function
      End If
   Loop Until Right$(a$, l%) <> DirSig
   GetNextFile = a$
End Function

Function HeadLine$(title$)
   '------------------------------------------------------------------
   'Restituisce una riga di 64 caratteri del tipo "===== title$ ====".
   '------------------------------------------------------------------
   f% = Len(title$)
   If ((f% \ 2) * 2) <> f% Then lc$ = "=" Else lc$ = ""
   f% = (64 - f%) \ 2
   bord$ = String$(f%, "=")
   HeadLine$ = Chr$(13) & Chr$(10) & bord$ & " " & title$ & " " & bord$ & lc$
End Function

Static Sub QSort(m$(), ByVal inizio%, ByVal fine%)
   '-----------------------------------------
   'Ordina tramite Quick Sort la matrice M$()
   'dall'indice inizio% all'indice fine%.
   '-----------------------------------------
   direzione% = -1
   If inizio% < fine% Then
      primo% = inizio%
      secondo% = fine%
      temp$ = m$(primo%)
      While primo% < secondo%
         If direzione% = -1 Then
            If LCase$(m$(secondo%)) < LCase$(temp$) Then
               m$(primo%) = m$(secondo%)
               direzione% = 0
               primo% = primo% + 1
            Else
               secondo% = secondo% - 1
            End If
         Else
            If LCase$(m$(primo%)) > LCase$(temp$) Then
               m$(secondo%) = m$(primo%)
               direzione% = -1
               secondo% = secondo% - 1
            Else
               primo% = primo% + 1
            End If
         End If
      Wend
      m$(primo%) = temp$
      QSort m$(), inizio%, primo% - 1
      QSort m$(), primo% + 1, fine%
   End If
End Sub

Function ValidName%(FileName$)
   '--------------------------------------
   'Controlla che il FileName$ sia un nome
   'valido per il DOS.
   '--------------------------------------
   Strm% = FreeFile
   On Error Resume Next
   Open FileName$ For Append As #Strm%
   If Err Then
      ValidName% = False
   Else
      Close #Strm%
      ValidName% = True
   End If
   On Error GoTo 0
End Function

Sub Visita(ByVal Nodo$, f%)
    '-----------------------------------------------------
    'Effettua la visita della directory Nodo$, stampando
    'sul file f% le sottodirectory, poi i file e poi
    'visitando tutte le sottodirectory.
    '-----------------------------------------------------
    Print #f%, Chr$(13); Chr$(10); DirHead; Chr$(34); Nodo$; Chr$(34)
    XdirBox.Label1.Caption = Nodo$
    XdirBox.Label1.Refresh

    'Search subdirectories first.
    Dim SubDir$()
    SubDirNum% = 0
    FileName$ = Nodo$ & "*.*"
    'Search first dirname.
    Nome$ = Dir(FileName$, vbDirectory)
    While Nome$ <> ""
        If (GetAttr(Nodo$ & Nome$) And vbDirectory) = vbDirectory And _
            Nome$ <> "." And Nome$ <> ".." Then
            SubDirNum% = SubDirNum% + 1
            ReDim Preserve SubDir$(1 To SubDirNum%)
            SubDir$(SubDirNum%) = Nome$
        End If
        Nome$ = Dir
    Wend
    'Sort data and print to file #f%.
    If SubDirNum% <> 0 Then
        QSort SubDir$(), 1, SubDirNum%
        For i% = 1 To SubDirNum%
            Print #f%, Chr$(34) & SubDir$(i%) & Chr$(34) & " " & DirSig
        Next i%
    End If

    'Search for files.
    Dim File$()
    FileFoundNum% = 0
    FileName$ = Nodo$ & "*.*"
    'Search first filename.
    Nome$ = Dir(FileName$, vbNormal + vbReadOnly + vbHidden + vbSystem)
    While Nome$ <> ""
        FileFoundNum% = FileFoundNum% + 1
        ReDim Preserve File$(1 To FileFoundNum%)
        File$(FileFoundNum%) = Chr$(34) & Nome$ & Chr$(34) & _
           " " & Format$(FileLen(Nodo$ & Nome$)) & _
           " " & Format$(FileDateTime(Nodo$ & Nome$), "yyyy/mm/dd hh:mm")
        Nome$ = Dir
    Wend
    'Sort data and print to the file.
    If FileFoundNum% <> 0 Then
        QSort File$(), 1, FileFoundNum%
        For i% = 1 To FileFoundNum%
            Print #f%, File$(i%)
        Next i%
    End If
   
    'Vist every subdir recursively.
    For i% = 1 To SubDirNum%
        Visita (Nodo$ & SubDir$(i%) & "\"), f%
    Next i%

End Sub

Sub WriteLog(LogFile$, Changes$(), ChangeCount%)
   '---------------------------------------------------------------------
   'Crea il file Log prima scrivendo la lista di tutte le modifiche che
   'trova in Changes$(), poi chiamando la procedura di confronto tra file.
   '---------------------------------------------------------------------
   f% = FreeFile
   Open LogFile$ For Output As #f%
   Print #f%, LogFile; " created on "; Format$(Now, "Long Date"); " at "; Format$(Now, "Short Time")
   If ChangeCount% > 0 Then
      QSort Changes$(), 1, ChangeCount%
      Tipo$ = ""
      For n% = 1 To ChangeCount%
         p$ = Left$(Changes$(n%), 2)
         a$ = Right$(Changes$(n%), Len(Changes$(n%)) - 2)
         If p$ <> Tipo$ Then
            Tipo$ = p$
            Select Case p$
               Case "MD"
                  t$ = "Created New Directory"
               Case "RD"
                  t$ = "Removed Directory"
               Case "NF"
                  t$ = "Added New File"
               Case "MF"
                  t$ = "Modified File"
               Case "RF"
                  t$ = "Removed File"
            End Select
            Print #f%, HeadLine$(t$)
         End If
         Print #f%, Chr$(34); a$; Chr$(34)
      Next n%
   End If

    'Compare all saved files.
    For i% = 1 To Glb_ScanFilesN%
        a$ = Format$(i%) & TempExt
        b$ = Glb_ScanFile$(i%)
        If Exist(a$) And Exist(b$) Then
            CompareFile a$, b$
        Else
            If Exist(b$) Then
                msg$ = "Created new " & b$ & " file."
                title$ = "Comparing file"
                MsgBox msg$, vbInformation, title$
            End If
        End If
    Next i%

    Close #f%
    
End Sub

