VERSION 5.00
Begin VB.Form SWatch 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Setup Watcher"
   ClientHeight    =   3075
   ClientLeft      =   1215
   ClientTop       =   2565
   ClientWidth     =   6855
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Icon            =   "Swatch.frx":0000
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   3075
   ScaleWidth      =   6855
   Begin VB.Frame Frame1 
      Caption         =   "Run..."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2655
      Left            =   2760
      TabIndex        =   4
      Top             =   180
      Width           =   3852
      Begin VB.DriveListBox Source_Drive 
         Appearance      =   0  'Flat
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   288
         Left            =   1800
         TabIndex        =   8
         Top             =   2160
         Width           =   1935
      End
      Begin VB.CommandButton Btn_ReRead 
         Appearance      =   0  'Flat
         Caption         =   "Re-read"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Left            =   120
         TabIndex        =   7
         Top             =   2160
         Width           =   1575
      End
      Begin VB.DirListBox Source_Dir 
         Appearance      =   0  'Flat
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   1584
         Left            =   1800
         TabIndex        =   6
         Top             =   360
         Width           =   1935
      End
      Begin VB.FileListBox Source_File 
         Appearance      =   0  'Flat
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   1395
         Left            =   120
         Pattern         =   "*.exe;*.com;*.bat"
         TabIndex        =   5
         ToolTipText     =   "Double click to start a program"
         Top             =   360
         Width           =   1572
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Logfile..."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2655
      Left            =   240
      TabIndex        =   0
      Top             =   180
      Width           =   2415
      Begin VB.FileListBox Log_List 
         Appearance      =   0  'Flat
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   1200
         Left            =   240
         Pattern         =   "*.log"
         TabIndex        =   3
         ToolTipText     =   "Double click to view a log file, Del to delete it"
         Top             =   1140
         Width           =   1935
      End
      Begin VB.CommandButton Btn_After 
         Appearance      =   0  'Flat
         Caption         =   "After Setup"
         Enabled         =   0   'False
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   312
         Left            =   240
         TabIndex        =   2
         ToolTipText     =   "Write a log file with changes from last snapshot"
         Top             =   720
         Width           =   1935
      End
      Begin VB.CommandButton Btn_Before 
         Appearance      =   0  'Flat
         Caption         =   "Before Setup"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   312
         Left            =   240
         TabIndex        =   1
         ToolTipText     =   "Take a snapshot of disks structure and system files"
         Top             =   360
         Width           =   1935
      End
   End
   Begin VB.Line Line1 
      BorderColor     =   &H80000003&
      X1              =   0
      X2              =   6720
      Y1              =   0
      Y2              =   0
   End
   Begin VB.Menu M_Menu 
      Caption         =   "&Menu"
      Begin VB.Menu M_Help 
         Caption         =   "&Help..."
         Shortcut        =   {F1}
      End
      Begin VB.Menu M_About 
         Caption         =   "&About Setup Watcher..."
      End
      Begin VB.Menu M_nul1 
         Caption         =   "-"
      End
      Begin VB.Menu M_Configuration 
         Caption         =   "&Configuration..."
      End
      Begin VB.Menu M_RestoreReg 
         Caption         =   "&Restore Registry..."
      End
      Begin VB.Menu M_nul2 
         Caption         =   "-"
      End
      Begin VB.Menu M_Exit 
         Caption         =   "E&xit"
      End
   End
End
Attribute VB_Name = "SWatch"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Sub Btn_After_Click()
    '-----------------------------------------------------------
    'Compara la struttura dei dischi fissi con quella salvata in
    'precedenza nei file-immagine nella directory del programma.
    'Usa un file temporaneo FileTemp.
    '-----------------------------------------------------------
    ChDrive ProgramDir$
    ChDir ProgramDir$
    'Richiede il nome da dare al file .LOG.
    prompt$ = "Type the name - without extension - to save the Logfile with:"
    title$ = "Save Logfile as..."
    Do
        LogFile$ = InputBox$(prompt$, title$)
        If LogFile$ = "" Then Exit Sub
        LogFile$ = LTrim$(RTrim$(LogFile$)) & ".log"
        If Exist(LogFile$) Then
            msg$ = AddBackslash$(ProgramDir$) & LogFile$ & Chr$(13)
            msg$ = msg$ & "This file already exists." & Chr$(13) & Chr$(13) & "Replace existing file?"
            If MsgBox(msg$, vbDefaultButton2 + vbExclamation + vbYesNo) <> vbYes Then LogFile$ = ""
        End If
    Loop Until ValidName%(LogFile$)
    
    ChangeCount% = 0
    Dim Changes$()
    'For each disk to watch...
    Screen.MousePointer = vbHourglass
    For i% = 1 To Len(DisksToWatch$)
        DrivePath$ = Mid$(DisksToWatch$, i%, 1) & ":\"
        ImageFile$ = Left$(DrivePath$, 1) & TempExt
        'Check if "before" image file exists.
        If Not (Exist(ImageFile$)) Then
            Screen.MousePointer = vbDefault
            title$ = "Making Logfile"
            msg$ = "Disk image file " & ImageFile$ & " not found."
            MsgBox msg$, vbExclamation, title$
            Screen.MousePointer = vbHourglass
        Else
            'Build the "after" image file.
            ExtDir DrivePath$, FileTemp
            r% = DoEvents()
            
            'Build a list of Changes$() on the disk.
            'At the end the array Changes$(ChangeCount%) will contain
            'a line for each change found. Each line begin with a pair
            'of chars as below:
            '"MD" New made directory.
            '"RD" Removed directory.
            '"NF" New file.
            '"MF" Modified file.
            '"RF" Removed file.
            
            'Image file before...
            f1% = FreeFile
            Open ImageFile$ For Input As #f1%
            'Image file after...
            f2% = FreeFile
            Open FileTemp For Input As #f2%

            DirSav$ = GetNextDir(f1%)
            DirNow$ = GetNextDir(f2%)
            While (DirSav$ <> Chr$(255)) Or (DirNow$ <> Chr$(255))
                'Normalize the paths to compare them.
                N_DirNow$ = NormPath$(DirNow$)
                N_DirSav$ = NormPath$(DirSav$)
                If N_DirNow$ < N_DirSav$ Then
                    'Found a new directory.
                    ChangeCount% = ChangeCount% + 1
                    ReDim Preserve Changes$(1 To ChangeCount%)
                    Changes$(ChangeCount%) = "MD" & DirNow$
                    DirNow$ = GetNextDir(f2%)
                ElseIf N_DirNow$ > N_DirSav$ Then
                    'A directory was removed.
                    ChangeCount% = ChangeCount% + 1
                    ReDim Preserve Changes$(1 To ChangeCount%)
                    Changes$(ChangeCount%) = "RD" & DirSav$
                    'All files within were removed too.
                    FileSav$ = GetNextFile(f1%)
                    While FileSav$ <> Chr$(255)
                        ChangeCount% = ChangeCount% + 1
                        ReDim Preserve Changes$(1 To ChangeCount%)
                        Changes$(ChangeCount%) = "RF" & DirSav$ & CutFileName$(FileSav$)
                        FileSav$ = GetNextFile(f1%)
                    Wend
                    DirSav$ = GetNextDir(f1%)
                Else
                    'Same folder, check files within.
                    FileSav$ = GetNextFile(f1%)
                    FileNow$ = GetNextFile(f2%)
                    While (FileSav$ <> Chr$(255)) Or (FileNow$ <> Chr$(255))
                        FileNameNow$ = CutFileName$(FileNow$)
                        FileNameSav$ = CutFileName$(FileSav$)
                        If LCase$(FileNameNow$) < LCase$(FileNameSav$) Then
                            'Found a new file.
                            ChangeCount% = ChangeCount% + 1
                            ReDim Preserve Changes$(1 To ChangeCount%)
                            Changes$(ChangeCount%) = "NF" & DirNow$ & FileNameNow$
                            FileNow$ = GetNextFile(f2%)
                        ElseIf LCase$(FileNameNow$) > LCase$(FileNameSav$) Then
                            'A file was deleted.
                            ChangeCount% = ChangeCount% + 1
                            ReDim Preserve Changes$(1 To ChangeCount%)
                            Changes$(ChangeCount%) = "RF" & DirSav$ & FileNameSav$
                            FileSav$ = GetNextFile(f1%)
                        Else
                            If LCase$(FileNow$) <> LCase$(FileSav$) Then
                            'Found a modified file.
                            Ignore% = False
                            FilePath$ = DirNow$ & FileNameNow$
                            If Not BinSearch%(Glb_IgnoreFile$(), _
                                Glb_IgnoreFilesN%, FilePath$) Then
                                ChangeCount% = ChangeCount% + 1
                                ReDim Preserve Changes$(1 To ChangeCount%)
                                Changes$(ChangeCount%) = "MF" & FilePath$
                            End If
                        End If
                        FileSav$ = GetNextFile(f1%)
                        FileNow$ = GetNextFile(f2%)
                    End If
                Wend
                DirSav$ = GetNextDir(f1%)
                DirNow$ = GetNextDir(f2%)
                End If
            Wend
            Close #f1%, #f2%
        End If
    Next i%
    
    'Write the log file.
    WriteLog LogFile$, Changes$(), ChangeCount%
    'Se richiesto cancella tutti i file temporanei.
    On Error Resume Next
    Kill FileTemp
    If KeepImageFiles% = 0 Then
        Kill "*" & TempExt
        Btn_After.Enabled = False
    End If
    On Error GoTo 0
    'Aggiorna la visualizzazione della finestra.
    Log_List.Refresh
    Btn_Before.SetFocus
    Screen.MousePointer = vbDefault
    'Chiede se visualizzare il log creato.
    msg$ = "Logfile saved as " & LogFile$ & "; do you want to read it now?"
    RetVal = MsgBox(msg$, vbInformation + vbYesNo)
    On Error Resume Next
    If RetVal = vbYes Then RetVal = Shell(Editor$ & " " & LogFile$, 1)
    If Err Then
        msg$ = "Unable to start " & Editor$ & "."
        MsgBox msg$, vbExclamation
    End If
    On Error GoTo 0
End Sub

Private Sub Btn_Before_Click()
   '---------------------------------------------------------------------
   'Crea nella directory attiva i file-immagine dei dischi fissi da
   'tenere sotto controllo (chiama la Sub ExtDir). Quindi effettua una
   'copia dei file specificati in Glb_ScanFile$().
   '---------------------------------------------------------------------
   ChDrive ProgramDir$
   ChDir ProgramDir$
   'Controlla se un set di dati esiste gi.
   If ExistSet%() Then
      title$ = "Saving disk images"
      msg$ = "Disk image files already exist. Replace?"
      r% = MsgBox(msg$, 308, title$)
      If r% <> 6 Then Exit Sub
   End If
   'Crea un'immagine per ogni disco elencato nella configurazione.
   For i% = 1 To Len(DisksToWatch$)
      Directory$ = Mid$(DisksToWatch$, i%, 1) & ":\"
      ExtDir Directory$, Left$(Directory$, 1) & TempExt
   Next i%
   'Crea una copia dei "Files to watch".
   For i% = 1 To Glb_ScanFilesN%
      File$ = Glb_ScanFile$(i%)
      If Not (Exist(File$)) Then
         title$ = "Making copy of a file"
         msg$ = "File " & File$ & " not found."
         r% = MsgBox(msg$, vbInformation, title$)
      Else
         'E' necessario il kill, altrimenti la copia non tronca alla lunghezza giusta.
         On Error Resume Next
         Kill Format$(i%) & TempExt
         On Error GoTo 0
         FileCopy File$, Format$(i%) & TempExt
      End If
   Next i%
   Btn_After.Enabled = ExistSet%()
End Sub

Private Sub Btn_ReRead_Click()
    Source_Dir.Refresh
    Source_File.Refresh
End Sub

Private Sub Form_Load()
   If App.PrevInstance = True Then End
   ProgramDir$ = CurDir$
   'Centra la finestra nello schermo.
   SWatch.Left = (Screen.Width - SWatch.Width) / 2
   SWatch.Top = (Screen.Height - SWatch.Height) / 2
   
   'Set some variables from the Registry.
   DefRunDrive$ = GetSetting(Glb_AppName, "Options", "RunDrive", "A:")
   Editor$ = GetSetting(Glb_AppName, "Options", "Editor", "Notepad.exe")
   KeepImageFiles% = Val(GetSetting(Glb_AppName, "Options", "KeepFiles", "1"))
   DisksToWatch$ = GetSetting(Glb_AppName, "Options", "Disks", "C")
   
   'Setup the lists of "Ignore Folders", "Ignore Files" and "Scan Files".
   Glb_IgnoreFoldersN% = Val(GetSetting(Glb_AppName, "IgnoreFolders", "Items", "0"))
   Glb_IgnoreFilesN% = Val(GetSetting(Glb_AppName, "IgnoreFiles", "Items", "0"))
   Glb_ScanFilesN% = Val(GetSetting(Glb_AppName, "ScanFiles", "Items", "0"))
   If Glb_IgnoreFoldersN% > 0 Then ReDim Glb_IgnoreFolder$(1 To Glb_IgnoreFoldersN%)
   If Glb_IgnoreFilesN% > 0 Then ReDim Glb_IgnoreFile$(1 To Glb_IgnoreFilesN%)
   If Glb_ScanFilesN% > 0 Then ReDim Glb_ScanFile$(1 To Glb_ScanFilesN%)
   For i% = 1 To Glb_IgnoreFoldersN%
      Glb_IgnoreFolder$(i%) = GetSetting(Glb_AppName, "IgnoreFolders", Format$(i%))
   Next i%
   For i% = 1 To Glb_IgnoreFilesN%
      Glb_IgnoreFile$(i%) = GetSetting(Glb_AppName, "IgnoreFiles", Format$(i%))
   Next i%
   For i% = 1 To Glb_ScanFilesN%
      Glb_ScanFile$(i%) = GetSetting(Glb_AppName, "ScanFiles", Format$(i%))
   Next i%
   
   'Enable the "After..." button if a snapshot set exists.
   Btn_After.Enabled = ExistSet%()
   'Set the Run box on the default drive.
   On Error Resume Next
   Source_Drive.Drive = DefRunDrive$
   On Error GoTo 0

End Sub

Private Sub Form_Unload(Cancel As Integer)
    Unload Help
    End
End Sub

Private Sub Log_List_DblClick()
   If Log_List.ListIndex >= 0 Then
      LogFile$ = Log_List.List(Log_List.ListIndex)
      On Error Resume Next
      RetVal = Shell(Config.Txt_Editor.Text & " " & LogFile$, 1)
      If Err Then
         msg$ = "Unable to start " & Config.Txt_Editor.Text & "."
         MsgBox msg$, vbExclamation
      End If
      On Error GoTo 0
   End If
End Sub

Private Sub Log_List_KeyDown(KeyCode As Integer, Shift As Integer)
   If Log_List.ListIndex >= 0 Then
      Select Case KeyCode
         Case 46
            msg$ = "Delete " & Log_List.List(Log_List.ListIndex) & "?"
            r% = MsgBox(msg$, 36)
            If r% = 6 Then
               On Error Resume Next
               Kill Log_List.List(Log_List.ListIndex)
               On Error GoTo 0
               Log_List.Refresh
            End If
         Case 13
            Log_List_DblClick
      End Select
   End If
End Sub

Private Sub M_About_Click()
   About.Show 1
End Sub

Private Sub M_Configuration_Click()
   '-------------------------------------------------------
   'Prima di mostrare la Form di configurazione effettua
   'l'Unload per forzarne il load successivo.
   '-------------------------------------------------------
   If Btn_After.Enabled Then
      msg$ = "WARNING: changes in configuration could" & Chr$(13) & "invalidate existing disk image files."
      If MsgBox(msg$, 49) = 2 Then Exit Sub
   End If
   Unload Config
   Config.Show 1
End Sub

Private Sub M_Exit_Click()
   Unload SWatch
End Sub

Private Sub M_Help_Click()
   Help.Show
End Sub

Private Sub M_RestoreReg_Click()
    If MsgBox("Do you want to remove the settings saved by this program in the Windows Registry? If you do so, you lost what is specified in the configuration menu.", vbYesNo + vbDefaultButton2 + vbExclamation) = vbYes Then
        'There is an error if no settings were ever saved.
        On Error Resume Next
        DeleteSetting Glb_AppName
        On Error GoTo 0
    End If
End Sub

Private Sub Source_Dir_Change()
   Source_File.Path = Source_Dir.Path
End Sub

Private Sub Source_Dir_KeyDown(KeyCode As Integer, Shift As Integer)
   If KeyCode = 13 Then Source_Dir.Path = Source_Dir.List(Source_Dir.ListIndex)
End Sub

Private Sub Source_Drive_Change()
   On Error Resume Next
   Save$ = Left$(Source_File.Path, 2)
   Source_File.Path = Source_Drive.Drive
   If Err Then Source_Drive.Drive = Save$
   Source_Dir.Path = Source_Drive.Drive
   On Error GoTo 0
End Sub

Private Sub Source_File_DblClick()
   If Right$(Source_File.Path, 1) <> "\" Then
      b$ = "\"
   Else
      b$ = ""
   End If
   a$ = Source_File.Path & b$ & Source_File.FileName
   If Not (Exist(a$)) Then
      Source_Dir.Refresh
      Source_File.Refresh
      Exit Sub
   End If
   ChDrive Source_File.Path
   ChDir Source_File.Path
   RetVal = Shell(a$, 1)
End Sub

Private Sub Source_File_KeyDown(KeyCode As Integer, Shift As Integer)
   If KeyCode = 13 Then Source_File_DblClick
End Sub

